/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.entities.MutantShulker;
import com.alexander.mutantmore.entities.MutantShulkerTurret;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import com.alexander.mutantmore.init.DamageSourceInit;
import com.alexander.mutantmore.init.ParticleTypeInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.util.HandleLoopingSoundInstances;
import com.alexander.mutantmore.util.MiscUtils;
import com.google.common.base.MoreObjects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantShulkerBullet
extends Projectile
implements IAnimatable,
IAnimationTickable {
    private static final EntityDataAccessor<Integer> HITS_LEFT = SynchedEntityData.m_135353_(MutantShulkerBullet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGETED_ENTITY_ID = SynchedEntityData.m_135353_(MutantShulkerBullet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int immuneTicks = 0;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int moveDelay = 0;
    public float damage = 0.0f;
    public boolean griefing = true;
    public boolean griefingDropsBlocks = false;
    public float explosionSize = 1.0f;
    public int levitationLength = 0;
    public int levitationLevel = 0;
    public boolean ignoresInvulTime = true;

    public MutantShulkerBullet(EntityType<? extends MutantShulkerBullet> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.setRemainingHits(3);
    }

    protected boolean m_5603_(Entity target) {
        return this.canHit(target) && super.m_5603_(target);
    }

    public void m_8119_() {
        HitResult hitresult;
        super.m_8119_();
        if (this.getTarget() != null || this.getTarget() == null) {
            ++this.moveDelay;
        }
        if (this.f_19853_.f_46443_) {
            ShakeCameraEvent.shake(this.f_19853_, 10, 0.0075f, this.m_20183_(), 5, CameraShakePriority.EFFECT);
        }
        if (this.immuneTicks > 0) {
            --this.immuneTicks;
        }
        if (!this.f_19853_.f_46443_ && (hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20101_();
        if (this.getTarget() != null) {
            if (!this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_60795_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.025, 0.0));
            }
            this.f_19790_ = this.m_20185_();
            this.f_19791_ = this.m_20186_();
            this.f_19792_ = this.m_20189_();
            if (this.moveDelay > 35 && (double)this.m_20270_(this.getTarget()) > 7.5) {
                double x = this.getTarget().m_20185_() - this.m_20185_();
                double y = this.getTarget().m_20186_() + (double)(this.getTarget().m_20206_() / 2.0f) - this.m_20186_();
                double z = this.getTarget().m_20189_() - this.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                this.m_20256_(this.m_20184_().m_82490_(0.85).m_82520_(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f).m_82490_(1.0));
                if (this.moveDelay >= 45) {
                    this.m_20334_(0.0, 0.0, 0.0);
                    this.m_20256_(this.m_20184_().m_82520_(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f).m_82490_(3.0));
                    this.moveDelay = 0;
                }
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.f_19853_.f_46443_ && this.immuneTicks <= 0) {
            Vec3 vec31 = this.m_20184_();
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypeInit.MUTANT_SHULKER_BULLET.get(), this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_ + 0.425, this.m_20189_() - vec31.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.f_19853_.f_46443_) {
            HandleLoopingSoundInstances.addMutantShulkerBulletAudio(this, this.f_19853_);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HITS_LEFT, (Object)0);
        this.f_19804_.m_135372_(TARGETED_ENTITY_ID, (Object)0);
    }

    public int getRemainingHits() {
        return (Integer)this.f_19804_.m_135370_(HITS_LEFT);
    }

    public void setRemainingHits(int attached) {
        this.f_19804_.m_135381_(HITS_LEFT, (Object)attached);
    }

    public Entity getTarget() {
        Entity target = this.f_19853_.m_6815_(this.getTargetID());
        if (!((Integer)this.f_19804_.m_135370_(TARGETED_ENTITY_ID) == 0 || target == null || !target.m_6084_() || target instanceof Player && target.m_5833_())) {
            return target;
        }
        return null;
    }

    public int getTargetID() {
        return (Integer)this.f_19804_.m_135370_(TARGETED_ENTITY_ID);
    }

    public void setTargetByID(int attached) {
        this.f_19804_.m_135381_(TARGETED_ENTITY_ID, (Object)attached);
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("RemainingHits", this.getRemainingHits());
        tag.m_128405_("TargetID", this.getTargetID());
        tag.m_128350_("Damage", this.damage);
        tag.m_128379_("Griefing", this.griefing);
        tag.m_128379_("GriefingDropsBlocks", this.griefingDropsBlocks);
        tag.m_128350_("ExplosionSize", this.explosionSize);
        tag.m_128405_("LevitationLength", this.levitationLength);
        tag.m_128405_("LevitationLevel", this.levitationLevel);
        tag.m_128379_("IgnoresInvulTime", this.ignoresInvulTime);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setRemainingHits(tag.m_128451_("RemainingHits"));
        this.setTargetByID(tag.m_128451_("TargetID"));
        this.damage = tag.m_128457_("Damage");
        this.griefing = tag.m_128471_("Griefing");
        this.griefingDropsBlocks = tag.m_128471_("GriefingDropsBlocks");
        this.explosionSize = tag.m_128457_("ExplosionSize");
        this.levitationLength = tag.m_128451_("LevitationLength");
        this.levitationLevel = tag.m_128451_("LevitationLevel");
        this.ignoresInvulTime = tag.m_128471_("IgnoresInvulTime");
    }

    public boolean m_7349_(Explosion p_19987_, BlockGetter p_19988_, BlockPos p_19989_, BlockState p_19990_, float p_19991_) {
        return p_19990_.getExplosionResistance(p_19988_, p_19989_, p_19987_) <= 9.0f && !p_19990_.m_204336_(TagInit.Blocks.UNBREAKABLE);
    }

    protected void m_5790_(EntityHitResult p_37345_) {
        super.m_5790_(p_37345_);
        MutantShulkerBullet damagingMob = this.m_37282_() != null ? this.m_37282_() : this;
        Entity entity = p_37345_.m_82443_();
        if (!(entity instanceof MutantShulkerBullet) && !(entity instanceof MutantShulker)) {
            LivingEntity livingentity;
            Entity entity1 = this.m_37282_();
            LivingEntity livingEntity = livingentity = entity1 instanceof LivingEntity ? (LivingEntity)entity1 : null;
            if (this.canHarm(entity)) {
                if (this.ignoresInvulTime) {
                    entity.f_19802_ = 0;
                }
                boolean flag = entity.m_6469_(DamageSourceInit.mutantShulkerBulletAttack((Entity)this, (Entity)livingentity).m_19366_(), this.damage);
                MiscUtils.customExplosion(this.f_19853_, (Entity)damagingMob, DamageSource.m_19373_(this.m_37282_() != null && this.m_37282_() instanceof LivingEntity ? (LivingEntity)this.m_37282_() : null).m_19366_(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), Mth.m_14036_((float)this.explosionSize, (float)1.0f, (float)Float.MAX_VALUE), false, this.explosionBlockInteraction(), (SoundEvent)SoundEventInit.MUTANT_SHULKER_PROJECTILE_IMPACT.get(), this.m_5720_(), (ParticleOptions)ParticleTypeInit.MUTANT_SHULKER_BULLET.get(), (ParticleOptions)ParticleTypeInit.MUTANT_SHULKER_BULLET.get(), this.damage, true, false);
                if (flag) {
                    this.m_19970_(livingentity, entity);
                    if (entity instanceof LivingEntity) {
                        ((LivingEntity)entity).m_147207_(new MobEffectInstance(MobEffects.f_19620_, this.levitationLength, this.levitationLevel), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)((Object)this)));
                    }
                }
            }
        } else if (entity instanceof MutantShulkerBullet) {
            entity.m_20256_(entity.m_20184_().m_82549_(this.m_20184_().m_82490_(0.75)));
        }
    }

    boolean canHarm(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_MUTANT_SHULKER_BULLET_CANT_HURT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantShulker)) {
            return true;
        }
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.PLAYER_MUTANT_SHULKER_BULLET_CANT_HURT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof Player)) {
            return true;
        }
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TURRET_MUTANT_SHULKER_BULLET_CANT_HURT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantShulkerTurret)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantShulker) && !(entity instanceof Player) && !(entity instanceof MutantShulkerTurret));
    }

    boolean canHit(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_MUTANT_SHULKER_BULLET_CANT_HIT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantShulker)) {
            return true;
        }
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.PLAYER_MUTANT_SHULKER_BULLET_CANT_HIT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof Player)) {
            return true;
        }
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TURRET_MUTANT_SHULKER_BULLET_CANT_HIT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantShulkerTurret)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantShulker) && !(entity instanceof Player) && !(entity instanceof MutantShulkerTurret));
    }

    protected void m_8060_(BlockHitResult p_37343_) {
        MutantShulkerBullet damagingMob;
        super.m_8060_(p_37343_);
        MutantShulkerBullet mutantShulkerBullet = damagingMob = this.m_37282_() != null ? this.m_37282_() : this;
        if (!this.f_19853_.f_46443_) {
            MiscUtils.customExplosion(this.f_19853_, (Entity)damagingMob, DamageSource.m_19373_(this.m_37282_() != null && this.m_37282_() instanceof LivingEntity ? (LivingEntity)this.m_37282_() : null).m_19366_(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), Mth.m_14036_((float)this.explosionSize, (float)1.0f, (float)Float.MAX_VALUE), false, this.explosionBlockInteraction(), (SoundEvent)SoundEventInit.MUTANT_SHULKER_PROJECTILE_IMPACT.get(), this.m_5720_(), (ParticleOptions)ParticleTypeInit.MUTANT_SHULKER_BULLET.get(), (ParticleOptions)ParticleTypeInit.MUTANT_SHULKER_BULLET.get(), this.damage, true, false);
        }
    }

    protected void m_6532_(HitResult p_37347_) {
        super.m_6532_(p_37347_);
        if (p_37347_.m_6662_() != HitResult.Type.ENTITY || !(((EntityHitResult)p_37347_).m_82443_() instanceof MutantShulkerBullet) && !(((EntityHitResult)p_37347_).m_82443_() instanceof MutantShulker)) {
            this.m_146870_();
        }
    }

    public Explosion.BlockInteraction explosionBlockInteraction() {
        if (this.griefing) {
            if (this.griefingDropsBlocks) {
                return Explosion.BlockInteraction.BREAK;
            }
            return Explosion.BlockInteraction.DESTROY;
        }
        return Explosion.BlockInteraction.NONE;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource p_37338_, float p_37339_) {
        if (this.immuneTicks <= 0) {
            if (p_37338_.m_7640_() != null) {
                this.m_37251_(p_37338_.m_7640_(), p_37338_.m_7640_().m_146909_(), p_37338_.m_7640_().m_146908_(), 0.0f, 0.5f, 1.0f);
                this.moveDelay = 0;
            }
            this.setRemainingHits(this.getRemainingHits() - 1);
            this.immuneTicks = 30;
            if (!this.f_19853_.f_46443_) {
                this.m_5496_(SoundEvents.f_12411_, 1.0f, 1.0f);
                if (this.getRemainingHits() <= 0) {
                    for (int i = 0; i < 3; ++i) {
                        if (this.f_19796_.m_188499_()) {
                            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.m_20208_(1.25), this.m_20187_(), this.m_20262_(1.25), 15, 0.2, 0.2, 0.2, 0.0);
                            continue;
                        }
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20208_(1.25), this.m_20187_(), this.m_20262_(1.25), 15, 0.2, 0.2, 0.2, 0.0);
                    }
                    this.m_146870_();
                } else {
                    for (int i = 0; i < 3; ++i) {
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20208_(1.25), this.m_20187_(), this.m_20262_(1.25), 15, 0.2, 0.2, 0.2, 0.0);
                    }
                }
            }
        }
        return true;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean canTarget(LivingEntity target) {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_bullet_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

